package gov.va.med.mhv.calendar.converter;

import org.springframework.core.convert.converter.Converter;

import gov.va.med.mhv.calendar.dto.VisnDTO;
import gov.va.med.mhv.calendar.model.Visn;

public class VisnConverter implements Converter<Visn, VisnDTO> {

	@Override
	public VisnDTO convert(Visn source) {
		VisnDTO target = new VisnDTO();
		
		target.setVisnId(source.getVisnId());
		target.setVisnName(source.getVisnName());
		
		return target;
	}

	public Visn convert(VisnDTO source) {
		Visn target = new Visn();
		
		target.setVisnId(source.getVisnId());
		target.setVisnName(source.getVisnName());
		
		return target;
	}
}
